$(function() {
var MouseGesture = function() {
};

MouseGesture.Modal = (function() {
	const GESTURE =
		[
			'gestureLeft',
			'gestureLeftUp',
			'gestureLeftDown',
			'gestureLeftRight',
			
			'gestureRight',
			'gestureRightUp',
			'gestureRightDown',
			'gestureRightLeft',
			
			'gestureUp',
			'gestureUpDown',
			'gestureUpLeft',
			'gestureUpRight',
			
			'gestureDown',
			'gestureDownUp', //未使用
			'gestureDownLeft',
			'gestureDownRight'
		],
		COMMAND_TEXT = 
		[
			'无',
			'后退',
			'前进',
			'上滚一屏',
			'下滚一屏',
			'上一个标签',
			'下一个标签',
			'上滚至页面顶部',
			'下滚至页面底部',
			'关闭当前标签',
			'关闭所有标签',
			'刷新当前标签',
			'恢复最近关闭标签',
			'新建标签',
			'关闭左边所有标签',
			'关闭右边所有标签',
			'关闭其他标签'
		];

	return {
		GESTURE: GESTURE,
		COMMAND_TEXT: COMMAND_TEXT,
		getAll: function(callback) {
			qqbrowser.extension.builtin.config.get(this.GESTURE, function(json) {
				var gestureCommands = JSON.parse(json)[0];
				callback(gestureCommands);
			});
		}
	};
})();

MouseGesture.View = {
	render: function(gestureCommands) {
		var command;
		$('tbody tr', contextMouseGesture).each(function(index, value) {
			command = gestureCommands['gesture' + this.dataset.gesture];
			this.dataset.command = command;
			$(this).find('td:last').text(MouseGesture.Modal.COMMAND_TEXT[command]);
		});
	}
};

MouseGesture.prototype = {
	init: function() {
		MouseGesture.Modal.getAll(MouseGesture.View.render);
	}
};

var mouseGesture = new MouseGesture();
mouseGesture.init();

var contextMouseGesture = document.getElementById('mouse-gesture');
var open = false;
var td;
var $message = $('.message', contextMouseGesture),
	$select = $('select', contextMouseGesture),
	select = $select[0];
	
// 否则只能用这个 document.defaultView.getComputedStyle(select).display
select.style.display = 'none';
var rightbody = document.getElementById('rightbody');
// mouseenter td 展示提示条；
// 同时select置于最上层并透明，这样用户看到的是提示条，点击则是展开select；
// 这是唯一一种一次点击就展开select的技术方案。
// $('td:nth-child(2)', contextMouseGesture).mouseenter();
function hover(target) {
	// select可见
	if (select.style.display !== 'none' && select.style.opacity === '1') {
		return;
	}
	
	td = target;
	
	// div#rightbody 设置了 position: absolute; 属性
	// 因此 .message 和 select 元素的 offsetParent 都是 div#rightbody元素
	// td 的 offsetParent 是 table 元素		
	var position = $(target).position();
	$message.css({
		left: position.left + rightbody.scrollLeft,
		top: position.top + rightbody.scrollTop
	});
	
	// 设置提示条的提示文字
	$('.message-hover', contextMouseGesture).show();

	$select.css({
		left: position.left + rightbody.scrollLeft,
		top: position.top + rightbody.scrollTop
	});
	
	// 设置select的位置，设置透明，并显示
	$select
		.css({opacity: 0})
		.show();

	// 设置默认值
	$('option[selected]').removeAttr('selected');
	$('option[value=' + target.parentNode.dataset.command + ']').attr('selected', '');
}

var mousemoveTarget = null;
$(document.body).mousemove(function(event) {
	if ($('#option-mousegesture').is(':hidden')) {
		return;
	}
	
	var target = event.target,
		$target = $(target);
	
	mousemoveTarget = target.tagName === 'SELECT' ? td : target;
	if ($target.is('#option-mousegesture td:last-child')) {
		mousemoveTarget = target;
	} else if ($target.is('#option-mousegesture select')) {
		mousemoveTarget = td;
	} else {
		mousemoveTarget = null;
	}
	
	// select可见
	if (select.style.display !== 'none' && select.style.opacity === '1') {
		return;
	}
	
	// select透明
	if ($target.is('#option-mousegesture select')) {
		return;
	}
	
	if ($target.is('#option-mousegesture td:last-child')) {
		hover(target);
		return;
	}
	
	// 否则隐藏
	$select.hide();
	$message.hide();
});

// 点击透明的select，隐藏信息提示，展示select
// 点击不透明的select，隐藏select
$select.click(function() {
	if (select.style.opacity === '0') {
		// select不透明
		select.style.opacity = '1';

		// 隐藏信息提示
		$('.message-hover', contextMouseGesture).hide();
	} else {
		$select.hide();
	}
});

$select.change(function() {
	var gestureName = 'gesture' + td.parentNode.dataset.gesture,
		command = Number(this.value),
		configData = {};
		
	configData[gestureName] = command;
	qqbrowser.extension.builtin.config.set(configData, function() {});
	
	td.innerText = MouseGesture.Modal.COMMAND_TEXT[command];
	td.parentNode.dataset.command = command;
	$select.hide();
	getResult();
});

$select.blur(function() {
	$select.hide();
});

// 按ESC键或者回车键，change事件比keyup事件先发生
$select.keyup(function(event) {
	if (event.keyCode === 27 || event.keyCode === 13) {
		$select.hide();
		mousemoveTarget && hover(mousemoveTarget);
	}
});

$('.reset', contextMouseGesture).click(function() {
	qqbrowser.extension.builtin.config.resetGestureFlag(function() {
		mouseGesture.init();
		getResult();
	});
});
});